#!/usr/bin/ruby1.8

$:.unshift('/home/solnet/bin/')
$:.unshift('/usr/share/solnet/libs/')

require 'optparse'
require 'reppkgs'
require 'repfrontend'

$VERSION = 0.2

$myname = File.basename($0)
$args = {
    :dist          => [],
    :component     => [],
    :action        => 'add',
    :reprepro      => '',
    :verbose       => 0,
    :repository    => '/home/solnet/produkty/repository',
    #:repository    => '/var/tmp/apt',
    :sync_host      => 'solnet@hosting2.solnet.cz',
    :sync_dir       => '/home/www/solnet-debian/debrp',
    # kdyz pridavam neco do techto komponent, pridavam balik zaroven i do multiboxu:
    :public_comps  => [ 'adopted', 'backports', 'open', 'multibox', 'filebox', 'firewall', 'mailbox' ],
    :log_levels    => ['error','warn','info','debug'],
}

opts = OptionParser.new do |opts|
    opts.banner = "Usage: #{$myname} [options] command [directory | package ] ..."

    opts.separator ""
    opts.separator "Commands:"

    opts.on("  add [packages]         - add packages to repository")
    opts.on("  remove <regexps>       - remove packages matching regexps")
    opts.on("  copy <pkg> <sd/sc> <td/tc> - copy package between dists/comps")
    opts.on("  move <pkg> <sd/sc> <td/tc> - move package between dists/comps")
    opts.on("  search <regexps>       - search for packages which match regexp")
    opts.on("  info <pkg_name>        - print info about selected package")
    opts.on("  list                   - list packages in distributions/components")
    opts.on("  sync                   - synchronize hosting")
    opts.on("  stats                  - print num/sizes of pkgs in dist/comp")
    opts.on("  check                  - check integrity of repository")
#    opts.on("  showdeps <d[/c[/p]]>   - prints dependencies of (p)ackages in (d)ist and (c)omponent on other packages")
    opts.on("  history <package>      - print history of add/remove for selected package")
#    opts.on("  init                   - initializes repository (creates pools, db files...)")
    opts.on("  getdists               - list available distributions")
    opts.on("  getcomps               - list available components in selected distributions ")
    opts.on("  newdist <dist>         - create new distribution")
    opts.on("  newcomp <dist/comp>    - create new component in dist")
    opts.on("  genhtaccess            - generate htaccess for each component")
    opts.on("  genpackages            - generate Packages file")
    opts.on("  unlock                 - delete lockfile")
#    opts.on("  addsame                - add to all dist/comps where is same version as in... ")
    opts.on("  help                   - print this help")
    

    opts.separator ""
    opts.separator "Specific options:"

    opts.on('-d', "--dist [DISTS | DISTS/COMPONENTS]",
        "separated by ',', default is 'any'", :REQUIRED) do |dist|
        if dist.match(/\//)
            dist, comp = dist.split('/')
            $args[:dist] = dist.split(',')
            $args[:component] = comp.split(',')
        else
            $args[:dist] = dist.split(',')
        end
    end

    opts.on('-c', "--component [COMP] (adopted,backports,open,multibox,common,filebox...) ",
    "separated by ',', default is 'any'", :REQUIRED) do |comp|
        comp and $args[:component] = comp.split(',')
    end

    #opts.on('-a', "--action (add, remove, check, search)") {|$args[:action]|}
    opts.on("--yes", "Non-interactive mode, use default answer when asked") { $args[:dontask] = 1 }
    opts.on("--nosync", "Don't synchronize with hosting", :NONE) { $args[:nosync] = 1 }
    opts.on("--nombox", "Don't add package to multibox", :NONE) { $args[:nosync] = 1 }
    opts.on("--force", "Replace newer/same version when adding package", :NONE) { $args[:force] = 1 }
    opts.on("--print0", "When printing packages (list/search...), print in format suitable for next processing", 
            :NONE) { $args[:print_format] = 'oneline' }
    opts.on("--nocolours", "Sexy output ;-)") { $args[:nocolours] = 1 }
    opts.on("--searchin", "Field (from debian control fields) to search in when searching", :REQUIRED) do |sf|
        $args[:search_field] = sf 
    end

    opts.separator ""
    opts.separator "Common options:"

    opts.on("--debug", "#{$args[:log_levels].join(',')}", "Set debug level", :REQUIRED) do |v|
        $args[:loglevel] = v
    end

    opts.on_tail("--version", "Show version") do
        puts $VERSION
        exit
    end

    opts.on_tail("-h", "--help", "Show this message") do
        puts opts
        exit
    end
end

if ARGV.length == 0
    $stderr.puts "ERROR: parameter 'action' is required\n\n"
    puts opts
    exit 1
end

opts.parse!(ARGV)
$args[:action] = ARGV.shift


# pokud pridavame balik, nechceme ho pridat vsude, ale jen 
# do defaultni 2006Qx/adpoted
if $args[:action] == 'add'
    $args[:dist] = [ '2006Q3' ] if $args[:dist].empty?
    $args[:component] = [ 'adopted' ] if $args[:component].empty?

    # FIXME: tyhle zavislosti tady nemaji byt
    isec = $args[:public_comps] & $args[:component]
    $args[:component].push('multibox') if not isec.empty?
    $args[:component].uniq!
end

$ui = RepositoryFrontendTerm.new($args)

if $args[:action] == 'add'
    $ui.add(ARGV)
elsif $args[:action] == 'list'
    $ui.list
elsif $args[:action] == 'copy'
    $ui.copy(ARGV[0], ARGV[1], ARGV[2])
elsif $args[:action] == 'move'
    $ui.move(ARGV[0], ARGV[1], ARGV[2])
elsif $args[:action] == 'remove'
    $ui.remove(ARGV)
elsif $args[:action] == 'check'
    $ui.check_repository
elsif $args[:action] == 'search'
    $ui.search(ARGV)
elsif $args[:action] == 'getdists'
    $ui.getdists
elsif $args[:action] == 'getcomps'
    $ui.getcomps
elsif $args[:action] == 'sync'
    $ui.sync
elsif $args[:action] == 'info'
    $ui.pkg_info(ARGV[0])
elsif $args[:action] == 'stats'
    $ui.stats
elsif $args[:action] == 'history'
    $ui.history(ARGV[0])
elsif $args[:action] == 'newdist'
    $ui.newdist(ARGV[0])
elsif $args[:action] == 'newcomp'
    $ui.newcomp(ARGV[0])
elsif $args[:action] == 'genhtaccess'
    $ui.genhtaccess
elsif $args[:action] == 'genpackages'
    $ui.genpackages
elsif $args[:action] == 'unlock'
    $ui.unlock
elsif $args[:action] == 'help'
    puts opts
else
    puts "unknown action '#{$args[:action]}', try '-h' fro help"
end

