=begin

= Name
  Term::ANSIColour v0.01 (unstable)

= Synopsis
   require 'term/ansicolour'

   print "Some ordinary text\n"
   Term::ANSIColour.colour = ('red')
   print "some red text..\n"
   print "some more red text..\n"
   Term::ANSIColour.colour = ('green')
   print "some green text..\n"
   Term::ANSIColour.colour = ('default')
   puts "some ordinary text.."
   puts "some magenta text".colour("magenta")
   puts "some funky text".colour("cyan", "bold", "on_white", "blink")
   puts "more ordinary text"

= Description
  prints out text in funny colours

= Class Methods
  --- Term::ANSIColour.colour
      Gets and sets the default output text colour (none by default)

= Overridden Methods
  --- print
      output text in the colour specified by Term::ANSIColour.colour
  --- String.colour( colour )
      returns a string of the colour given in the argument (overriding Term::ANSIColour.colour).

= To Do
  --- Get puts, printf, putc and write to output coloured text.
  --- Write some proper documentation.
  --- Make the interface a bit cleaner.
  --- Allow people to use string modifiers, constants, or overridden output
      methods depending on their taste.
  --- Plug in a few enhancements such as regexp colouring, syntax highlighting
      and the like.
  --- Alias @@colour to @color
  --- Learn how to code ruby before I break something.

= Credits
  First version by Robert Ryan (rjr@rollmop.org) borrowing extensively from
  the perl version by Russ Allbery and Zenin. Additional input by Mark Hulme-Jones.
  
= Copyright

Copyright 2002

This program is free software. You can redistribute it and/or modify
it under the same terms as Ruby itself.
  
=cut

=end

module Term
  module ANSIColour
    # XXX - why don't attr_reader and attr_writer work?
    @@colour = ['reset']

    def ANSIColour.colour
      @@colour
    end

    def ANSIColour.colour=(*string)
      # why does this seem to work?
      @@colour = string[0]

      # why won't his work?
      # @@colour = string

      return @@colour
    end

    def ANSIColour.attributes
      { 'default'    => '0',
        'clear'      => '0',
        'reset'      => '0',
        'bold'       => '1',
        'dark'       => '2',
        'underline'  => '4',
        'blink'      => '5',
        'reverse'    => '7',
        'concealed'  => '8',

        'black'      => '30',   'on_black'   => '40',
        'red'        => '31',   'on_red'     => '41',
        'green'      => '32',   'on_green'   => '42',
        'yellow'     => '33',   'on_yellow'  => '43',
        'blue'       => '34',   'on_blue'    => '44',
        'magenta'    => '35',   'on_magenta' => '45',
        'cyan'       => '36',   'on_cyan'    => '46',
        'white'      => '37',   'on_white'   => '47'
      }
    end
  end
end

class String
  def colour(newcolour, *colours)
    attr = Term::ANSIColour.attributes
    [newcolour, colours].flatten.map {|c| "\e\[#{attr[c]}m"}.join + self.to_s + "\e\[#{attr['reset']}m"
  end

  alias color colour
end

module Kernel
  include Term::ANSIColour

  alias_method :orig_print, :print
  #alias_method :orig_puts, :puts # XXX - still has issues passing a list

  def print(str)
    colours = Term::ANSIColour.colour
    attr    = Term::ANSIColour.attributes
    orig_print ( attr[colours[0]] == 0 ? str :
                 colours.map{|c| "\e\[#{attr[c]}m"}.join + str + "\e\[#{attr['reset']}m"
               )
  end
  # XXX - todo - get puts, printf and putc to ouput in colour.
end
