require 'sqlite3'
require 'ostruct'

class RepositoryDB

    def initialize(args={})
        @args = {
        }.update(args)
        unless File.file?(@args[:pkgfile])
            puts "db '#{@args[:pkgfile]}' doesn't exist, creating..."
            initdb
        end
        @db = SQLite3::Database.new(@args[:pkgfile])
    end


    # vytvori novou db s info o balicich
    def initdb
        if @args[:pkgfile] == nil or @args[:pkgfile] == ''
            log("dbfile is not set")
            return
        end
        if File.file?(@args[:pkgfile])
            log("dbfile '#{@args[:pkgfile]}' already exists, aborting")
            return
        end
        log("creating pkginfo db '#{@args[:pkgfile]}'")
        db = SQLite3::Database.new(@args[:pkgfile])
        db.execute "create table pkgs (name varchar(100), distribution varchar(50),
            component varchar(50), info text, primary key 
            (name,distribution,component));"
    end


    # vraci hash baliku ze zadane dist/komponenty nebo
    # nil pokud balik v poolu neni
    def get_pkg(pkgname, dist, comp)
        pkgname = SQLite3::Database.quote(pkgname)
        comp = SQLite3::Database.quote(comp)
        dist = SQLite3::Database.quote(dist)
        row = @db.get_first_row("select info from pkgs where name='#{pkgname}' and distribution='#{dist}' and component='#{comp}'")
        return row ? Marshal.load(row[0].unpack('m')[0]) : nil
    end


    def get_pkg_byname(pkgname)
        pkgs = {}
        pkgname = SQLite3::Database.quote(pkgname)
        query = "select distribution, component, info from pkgs where name='#{pkgname}'"
        @db.execute(query) do |row|
            pkgs[row[0]] or pkgs[row[0]] = {}
            pkgs[row[0]][row[1]] = Marshal.load(row[2].unpack('m')[0])
        end
        return pkgs
    end
        
    def save_pkg(pkg)
        info = SQLite3::Database.quote([Marshal.dump(pkg)].pack('m'))
        query = "insert into pkgs values ('#{pkg['Package']}','#{pkg['_Distribution']}','#{pkg['_Component']}','#{info}')"
        @db.execute(query)
    end


    def remove_pkg(pkgname, dist, comp)
        pkgname = SQLite3::Database.quote(pkgname)
        comp = SQLite3::Database.quote(comp)
        dist = SQLite3::Database.quote(dist)
        query = "delete from pkgs where name='#{pkgname}' and distribution='#{dist}' and component='#{comp}'"
        @db.execute(query)
        #return pkg
    end


    # vraci hash (jmen baliku) hashi (distribuci) hashi (komponent) v zadanych dist/comp
    # 'dist' je hash (distribuci) hashi (komponent), ktere se maji vylistovat
    def get_pkgs(dists)
        locs = []
        pkgs = {}
        dists.each do |dist, comps|
            dist = SQLite3::Database.quote(dist)
            comps.keys.each do |comp|
                comp = SQLite3::Database.quote(comp)
                locs.push("(distribution='#{dist}' and component='#{comp}')")
            end
        end
        where = "where " + locs.join(' or ')
        query = "select name, distribution, component, info from pkgs #{where}"
        @db.execute(query) do |row|
            pkgname = row[0]
            dist = row[1]
            comp = row[2]
            info = Marshal.load(row[3].unpack('m')[0])
            pkgs[pkgname] or pkgs[pkgname] = {}
            pkgs[pkgname][dist] or pkgs[pkgname][dist] = {}
            pkgs[pkgname][dist][comp] or pkgs[pkgname][dist][comp] = {}
            pkgs[pkgname][dist][comp] = info
        end
        return pkgs
    end


    # vraci hash s infama baliku ze zadane distribuce a komponenty
    def get_pkgs_from_dist_comp(dist, comp)
        pkgs = {}
        dist = SQLite3::Database.quote(dist)
        comp = SQLite3::Database.quote(comp)
        query = "select name, info from pkgs where distribution='#{dist}' and component='#{comp}'"
        @db.execute(query) do |row|
            pkgs[row[0]] or pkgs[row[0]] = {}
            pkgs[row[0]] = Marshal.load(row[1].unpack('m')[0])
        end
        return pkgs
    end


    def log(msg)
        puts msg
    end


    def _quote(str)
        qstr = str ? SQLite3::Database.quote(str) : ''
        return qstr
    end
end
